/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.moduleviews;

import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModuleView;
import com.minecolonies.api.colony.buildings.modules.settings.ISetting;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingsModuleView;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.modules.SettingsModuleWindow;
import com.minecolonies.coremod.colony.buildings.modules.settings.SettingKey;
import com.minecolonies.coremod.network.messages.server.colony.building.TriggerSettingMessage;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class SettingsModuleView
extends AbstractBuildingModuleView
implements ISettingsModuleView {
    final Map<ISettingKey<?>, ISetting> settings = new LinkedHashMap();

    @Override
    public void deserialize(@NotNull FriendlyByteBuf buf) {
        this.settings.clear();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            ResourceLocation key = buf.m_130281_();
            ISetting setting = (ISetting)StandardFactoryController.getInstance().deserialize(buf);
            this.settings.put(new SettingKey(setting.getClass(), key), setting);
        }
    }

    public Map<ISettingKey<?>, ISetting> getSettings() {
        return this.settings;
    }

    public List<ISettingKey<?>> getActiveSettings() {
        ArrayList activeSettings = new ArrayList();
        for (Map.Entry<ISettingKey<?>, ISetting> setting : this.settings.entrySet()) {
            if (!setting.getValue().isActive(this)) continue;
            activeSettings.add(setting.getKey());
        }
        return activeSettings;
    }

    @Override
    public <T extends ISetting> T getSetting(ISettingKey<T> key) {
        return (T)((ISetting)this.settings.getOrDefault(key, null));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BOWindow getWindow() {
        return new SettingsModuleWindow("minecolonies:gui/layouthuts/layoutsettings.xml", this.buildingView, this);
    }

    @Override
    public String getIcon() {
        return "settings";
    }

    @Override
    public String getDesc() {
        return "com.minecolonies.coremod.gui.workerhuts.settings";
    }

    @Override
    public void trigger(ISettingKey<?> key) {
        ISetting setting = this.settings.get(key);
        setting.trigger();
        Network.getNetwork().sendToServer(new TriggerSettingMessage(this.buildingView, key, setting));
    }
}

